var NO = 0;
var NC = 1;

var xAxis = 1;
var yAxis = 2;
var zAxis = 3;
var aAxis = 4;
var bAxis = 5;

function sleep(tm)
{
  if (typeof(fsHost) === 'object')
    fsHost.Sleep(tm);
}

function log(str)
{
  if (typeof(fsHost) === 'object')
    fsHost.Log(str)
  else if (typeof(console) === 'object')
    console.log(str)
}

function output(port, state)
{
  if (typeof(fsGPIO) === 'object')
  {
    var portNum = 0;

    if (typeof(port) === 'string')
    {
      portNum = fsHost.StrToPort(port);
    }
    else if (typeof(port) === 'number')
    {
      portNum = port;
    }
    else 
    {
      throw "output port params error";
    }
    
    if (typeof(state) === 'undefined')
    {
      return fsGPIO.GetOutputBit(portNum) > 0;
    }
    else if (typeof(state) === 'boolean')
    {
      return fsGPIO.SetOutputBit(portNum, state) > 0;
    }
    else 
    {
      throw "output state params error";
    }
  };
  
  return false;
}

function defInport(port, logic)
{
  return {
    portNum: port,
    portLogic: logic
  }
}

function input(port)
{
  if (typeof(fsGPIO) === 'object')
  {
    var portNum = 0;
    var portLogic = NO;

    if (typeof(port) === 'object')
    {
      if (typeof(port.portNum) === 'string')
      {
        portNum = fsHost.StrToPort(port.portNum);
      }
      else 
        portNum = port.portNum;

      if (typeof(port.portLogic) === 'number')
        portLogic = port.portLogic;
    }
    else if (typeof(port) === 'string')
    {
      portNum = fsHost.StrToPort(port);
    }
    else if (typeof(port) === 'number')
    {
      portNum = port;
    }
    else
    { 
       throw "input port params error";
    }

    return (fsGPIO.GetInputBit(portNum) ^ portLogic) > 0;
  }; 
  
  return false;
}

function doExecCustomPlc(plcnum, waittime)
{
  var task = {
    doExec: function ()
      {
        fsNc.RunCustomStep(plcnum)
      },
    isEnd: function ()  
      {
        return fsNc.CustomStepIsEnd();  
      },
    doFailed: function ()
    {
      fsNc.StopCustomStep();
    }
  };

  var checktime;
  if ((typeof(waittime) == 'number') && (waittime > 0))
    checktime = waittime;
  else 
    checktime = null;
  task.timeout = checktime;

  return doTask(task);
}

function doMoveCommAxis(commaxis, pos, async)
{
  var task = {
    doExec: function ()
    {
      fsNc.CommAxisMoveTo(commaxis, pos);
    },
    isEnd: function ()  
    {
      if ((typeof(async) === 'boolean') && async)
      {
        return true;
      }
      else
        return fsNc.CommAxisIsBusy(commaxis) == false;
    },
    doFailed: function()
    {
      fsNc.CommAxisStop(commaxis);   
    }
  };

  return doTask(task);
}

function doWaitCommAxis(commaxis, waittime)
{
  var task = {
    isEnd: function ()  
    {
      return fsNc.CommAxisIsBusy(commaxis) == false;
    },
    doFailed: function()
    {
      fsNc.CommAxisStop(commaxis);   
    }
  };

  var checktime;
  if ((typeof(waittime) == 'number') && (waittime > 0))
    checktime = waittime;
  else 
    checktime = null;
  task.timeout = checktime;

  return doTask(task);
}

function doWaitInputs(ports)
{
  if (typeof(ports) === 'object')
  {
    for (var i = 0; i < ports.length; i ++)
    {
      var task = {
        isEnd: function ()  
          {
            return input(ports[i]);
          }
      }
      if (!doTask(task))
        return false;
    }
    return true;
  }
  return false;
}

function doWaitInput(port, waittime)
{
  var task = {
    isEnd: function ()  
      {
        return input(port);
      }
  }

  var checktime;
  if ((typeof(waittime) == 'number') && (waittime > 0))
    checktime = waittime;
  else 
    checktime = null;
  task.timeout = checktime;

  return doTask(task);
}

function isReqStop()
{
  if (typeof(fsHost) === 'object')
    return fsHost.IsReqStop();
  else
    return false;
}

function doTask(obj)
{
  var Monitor = function (initTm)
  {
    while (true) 
    {
      if ((typeof(obj.isEnd) === 'function') && (obj.isEnd())) 
        return true;

      sleep(1);
      if (isReqStop())
      {
        return false;
      }
      
      if ((typeof(initTm) === 'object') && (typeof(obj.timeout) === 'number'))
      {
        var runTm = new Date();
        if (runTm.getTime() - initTm.getTime() > obj.timeout)
          return false;
      }

      if ((typeof(obj.isEnd) !== 'function') && (typeof(obj.timeout) !== 'number'))
      {
        return true;
      }
    }
  }
  
  if (typeof(obj) === 'object')
  {
    if (typeof(obj.doExec) === 'function')
    {
      obj.doExec(); 
    }

    if (! Monitor(new Date()))
    {
      if (typeof(obj.doFailed) === 'function')
      {
        obj.doFailed(); 
      }
      return false;
    }
    
    if (typeof(obj.doSuccess) === 'function')
    {
      obj.doSuccess(); 
    }
    return true;
  }
  return false;     
}

function doTasks(taskarray)
{
  if (typeof(taskarray) === 'object')
  {
    for (var i = 0; i < taskarray.length; i ++)
    {
      if (!doTask(taskarray[i]))
        return false;
    }
    return true;
  }

  return false;
}

function JsConfigInit()
{
  for (var i = 0; i < JsConfig.params.length; i++)
  {
    var value; 
    if (typeof(JsConfig.params[i].value) == 'string')
      value = "'" + JsConfig.params[i].value + "'";
    else 
      value = JsConfig.params[i].value;
    eval("JsConfig." + JsConfig.params[i].name + "=" + value);
  }
}

function CommAxisParalMoveTo(AxisNumArr, Pos){
  if (!typeof(AxisNumArr) == 'array'){
      return false;
  }

  var nA = AxisNumArr.length;
  if (nA < 1){
      return false;
  }
  for (var i=0;i<nA;i++){
      fsNc.CommAxisMoveTo(AxisNumArr[i], Pos);
  }

  var tmpTask = {
      isEnd: function(){
          for (var i=0;i<nA;i++){
              if (fsNc.CommAxisIsBusy(AxisNumArr[i])){
                  return false;
              }
          }
          return true;
      },
      timeout: 1000*1000,
      doFailed: function(){
          for (var i=0;i<nA;i++){
              fsNc.CommAxisStop(AxisNumArr[i]);
          } //ֹͣͨ˶
     }
  }

  return doTask(tmpTask);
}

function CommAxisParalMoveBy(AxisNumArr, Des){
  if (!typeof(AxisNumArr) == 'array'){
      return false;
  }

  var nA = AxisNumArr.length;
  if (nA < 1){
      return false;
  }
  for (var i=0;i<nA;i++){
      fsNc.CommAxisMoveBy(AxisNumArr[i], Des);
  }

  var tmpTask = {
      isEnd: function(){
          for (var i=0;i<nA;i++){
              if (fsNc.CommAxisIsBusy(AxisNumArr[i])){
                  return false;
              }
          }
          return true;
      },
      timeout: 1000*1000,
      doFailed: function(){
          for (var i=0;i<nA;i++){
              fsNc.CommAxisStop(AxisNumArr[i]);
          } //ֹͣͨ˶
     }
  }

  return doTask(tmpTask);
}